package pt.cff.tp04_01;

import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {

    private static final String TAG="MainActivity:";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_main);
        TextView t = findViewById(R.id.textView);
        t.setText("muda o texto");
        Log.i(getString(R.string.app_name), TAG + "onCreate");
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        Log.i(getString(R.string.app_name), TAG + "onSaveInstanceState");
    }

    @Override
    protected void onStart() {
        super.onStart();
        Log.i(getString(R.string.app_name), TAG + "onStart");
    }
    @Override
    protected void onRestart() {
        super.onRestart();
        Log.i(getString(R.string.app_name),TAG + "onRestart");
    }
    @Override
    protected void onResume() {
        super.onResume();
        Log.i(getString(R.string.app_name),TAG + "onResume");
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        Log.i(getString(R.string.app_name), TAG + "onRestoreInstanceState");
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.i(getString(R.string.app_name),TAG + "onPause");
    }
    @Override
    protected void onStop() {
        super.onStop();
        Log.i(getString(R.string.app_name), TAG + "onStop");
    }
    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.i(getString(R.string.app_name), TAG + "onDestroy");
    }

}
